﻿/*
VERSION:		1.0

DEPENDANCIES:
	DoubleClick.as
	EventSystem.as

USAGE:
	_global.MOUSE = new MyMouse();
	MOUSE.addEvent( "onDoubleClick", "myFunction", this );

*/



class MyMouse extends Mouse
{
	// custom event system
	var doEvent;
	var addEvent;
	var removeEvent;
	
	// DoubleClick system
	var doubleClick
	
	function MyMouse()
	{
		// listen to mouse
		Mouse.addListener(this);
		EventSystem.addEventSystem(this);
		
		// Enable double-clicking
		this.doubleClick = new DoubleClick();
		doubleClick.addListener( this );
	}// CONSTRUCTOR
	
	
	
	function onMouseDown()
	{
		this.doEvent("onMouseDown");
	}// onMouseDown()
	
	function onMouseUp()
	{
		this.doEvent("onMouseUp");
	}// onMouseDown()
	
	function onMouseMove()
	{
		this.doEvent("onMouseMove");
	}// onMouseDown()
	
	function onDoubleClick()
	{
		this.doEvent("onDoubleClick");
	}// onDoubleClick()
}// MyMouse